﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
/**
 * <p>Contains the output of RequestSpotFleet.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RequestSpotFleetResponse">AWS
 * API Reference</a></p>
 */
class RequestSpotFleetResponse {
 public:
  AWS_EC2_API RequestSpotFleetResponse() = default;
  AWS_EC2_API RequestSpotFleetResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API RequestSpotFleetResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The ID of the Spot Fleet request.</p>
   */
  inline const Aws::String& GetSpotFleetRequestId() const { return m_spotFleetRequestId; }
  template <typename SpotFleetRequestIdT = Aws::String>
  void SetSpotFleetRequestId(SpotFleetRequestIdT&& value) {
    m_spotFleetRequestIdHasBeenSet = true;
    m_spotFleetRequestId = std::forward<SpotFleetRequestIdT>(value);
  }
  template <typename SpotFleetRequestIdT = Aws::String>
  RequestSpotFleetResponse& WithSpotFleetRequestId(SpotFleetRequestIdT&& value) {
    SetSpotFleetRequestId(std::forward<SpotFleetRequestIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  RequestSpotFleetResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_spotFleetRequestId;
  bool m_spotFleetRequestIdHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
