/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.text.CharacterIterator;
import sun.text.CodePointIterator;

final class CharacterIteratorCodePointIterator
extends CodePointIterator {
    private CharacterIterator iter;

    public CharacterIteratorCodePointIterator(CharacterIterator characterIterator) {
        this.iter = characterIterator;
    }

    @Override
    public void setToStart() {
        this.iter.setIndex(this.iter.getBeginIndex());
    }

    @Override
    public void setToLimit() {
        this.iter.setIndex(this.iter.getEndIndex());
    }

    @Override
    public int next() {
        char c = this.iter.current();
        if (c != '\uffff') {
            char c2 = this.iter.next();
            if (Character.isHighSurrogate(c) && c2 != '\uffff' && Character.isLowSurrogate(c2)) {
                this.iter.next();
                return Character.toCodePoint(c, c2);
            }
            return c;
        }
        return -1;
    }

    @Override
    public int prev() {
        char c = this.iter.previous();
        if (c != '\uffff') {
            if (Character.isLowSurrogate(c)) {
                char c2 = this.iter.previous();
                if (Character.isHighSurrogate(c2)) {
                    return Character.toCodePoint(c2, c);
                }
                this.iter.next();
            }
            return c;
        }
        return -1;
    }

    @Override
    public int charIndex() {
        return this.iter.getIndex();
    }
}

