/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results;

import java.util.HashSet;
import java.util.Set;
import org.graalvm.visualvm.lib.jfluid.results.DataManagerListener;

public abstract class DataManager {
    private final Set listeners = new HashSet();

    public void addDataListener(DataManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeDataListener(DataManagerListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataChanged() {
        HashSet toNotify;
        if (this.listeners.isEmpty()) {
            return;
        }
        Set set = this.listeners;
        synchronized (set) {
            toNotify = new HashSet(this.listeners);
        }
        for (DataManagerListener listener : toNotify) {
            listener.dataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataReset() {
        HashSet toNotify;
        if (this.listeners.isEmpty()) {
            return;
        }
        Set set = this.listeners;
        synchronized (set) {
            toNotify = new HashSet(this.listeners);
        }
        for (DataManagerListener listener : toNotify) {
            listener.dataReset();
        }
    }
}

