/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.checkBoxTree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeData;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodePanel;

public class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private final CheckBoxNodePanel panel = new CheckBoxNodePanel();
    private final DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
    private final Color selectionForeground;
    private final Color selectionBackground;
    private final Color textForeground;
    private final Color textBackground;

    public CheckBoxNodeRenderer() {
        Font fontValue = UIManager.getFont("Tree.font");
        if (fontValue != null) {
            this.panel.getLabel().setFont(fontValue);
        }
        Boolean focusPainted = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.panel.check.setFocusPainted(focusPainted != null && focusPainted != false);
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
    }

    protected CheckBoxNodePanel getPanel() {
        return this.panel;
    }

    public void addNodeListener(MouseAdapter listener) {
        this.panel.addMouseListener(listener);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node;
        Object userObject;
        CheckBoxNodeData data = null;
        if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof CheckBoxNodeData) {
            data = (CheckBoxNodeData)userObject;
        }
        this.panel.setSelected(Boolean.FALSE);
        this.panel.setEnabled(tree.isEnabled());
        if (selected) {
            this.panel.setForeground(this.selectionForeground);
            this.panel.setBackground(this.selectionBackground);
            this.panel.getLabel().setForeground(this.selectionForeground);
            this.panel.getLabel().setBackground(this.selectionBackground);
        } else {
            this.panel.setForeground(this.textForeground);
            this.panel.setBackground(this.textBackground);
            this.panel.getLabel().setForeground(this.textForeground);
            this.panel.getLabel().setBackground(this.textBackground);
        }
        if (data == null) {
            return this.defaultRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        this.panel.setData(data);
        this.panel.setSelected(data.isSelected());
        return this.panel;
    }
}

