/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.editorkit;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEditorKit<T extends EditorKitFactory>
implements EditorKit {
    private final Logger logger = LoggerFactory.getLogger(AbstractEditorKit.class);
    private final Map<Object, Disposable> objects = new HashMap<Object, Disposable>();
    private final T editorKitFactory;

    public AbstractEditorKit(@Nonnull T editorKitFactory) {
        this.editorKitFactory = (EditorKitFactory)Preconditions.checkNotNull(editorKitFactory);
    }

    @Override
    public void put(@Nullable Object key, @Nullable Disposable value) {
        this.objects.put(key, value);
    }

    @Override
    @Nullable
    public Disposable get(@Nullable Object key) {
        return this.objects.get(key);
    }

    @Nonnull
    public T getEditorKitFactory() {
        return this.editorKitFactory;
    }

    @Override
    public void dispose() {
        for (Disposable object : this.objects.values()) {
            try {
                object.dispose();
            }
            catch (Exception e) {
                this.logger.error("An error occurred whilst disposing of an Editor Kit object.  Object: ", (Object)object, (Object)e);
            }
        }
        this.objects.clear();
    }
}

