/*
 * Decompiled with CFR 0.152.
 */
package hughai.loader;

import com.springrts.ai.AI;
import com.springrts.ai.oo.AIFloat3;
import com.springrts.ai.oo.AbstractOOAI;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.WeaponDef;
import hughai.loader.utils.IHughAI;
import hughai.loader.utils.Loader;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class HughAILoader
extends AbstractOOAI
implements AI {
    final String underlyingJarFileName = "UnderlyingAI.jar";
    final String underlyingClassNameToLoad = "hughai.CSAI";
    final String reloadCommandString = ".hughai reload";
    private int skirmishId = -1;
    private Properties info = null;
    private Properties optionValues = null;
    private OOAICallback callback = null;
    private String myLogFile = null;
    private Logger log = null;
    private static final int DEFAULT_ZONE = 0;
    IHughAI underlyingAI;
    Thread reloadThread;

    HughAILoader() {
    }

    private int sendTextMsg(String string) {
        try {
            this.callback.getGame().sendTextMessage(string, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int init(int n, OOAICallback oOAICallback) {
        this.skirmishId = n;
        this.callback = oOAICallback;
        int n2 = 0;
        try {
            this.loadUnderlyingAI();
            if (this.underlyingAI != null) {
                n2 = this.underlyingAI.init(n, oOAICallback);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.release(22);
            n2 = 22;
        }
        return n2;
    }

    public int release(int n) {
        try {
            if (this.underlyingAI != null) {
                this.underlyingAI.Shutdown();
            }
            this.underlyingAI = null;
            System.runFinalization();
            System.gc();
            System.gc();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 21;
        }
        return 0;
    }

    public int update(int n) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.update(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    void loadUnderlyingAI() throws Exception {
        String string = this.callback.getDataDirs().getConfigDir() + new String(new byte[]{(byte)this.callback.getDataDirs().getPathSeparator()}) + "UnderlyingAI.jar";
        this.sendTextMsg("Reloading ai from " + string + " ...");
        File file = new File(string);
        URL[] uRLArray = new URL[]{file.toURI().toURL()};
        System.out.println("about to load AI...");
        this.underlyingAI = Loader.loadOOAI(uRLArray, "hughai.CSAI");
        this.underlyingAI.setHughAILoader(this);
    }

    String longToMeg(long l) {
        float f = (float)l / 1024.0f / 1024.0f;
        return "" + f + "MB";
    }

    void dumpSystemStats() {
        Runtime runtime = Runtime.getRuntime();
        System.out.println("total: " + this.longToMeg(runtime.totalMemory()) + " free: " + this.longToMeg(runtime.freeMemory()) + " used: " + this.longToMeg(runtime.totalMemory() - runtime.freeMemory()));
    }

    void doReloadAI() throws Exception {
        this.sendTextMsg("Reloading ai " + this.skirmishId + " ...");
        this.underlyingAI.Shutdown();
        this.underlyingAI = null;
        System.runFinalization();
        System.gc();
        System.gc();
        this.dumpSystemStats();
        this.loadUnderlyingAI();
        this.underlyingAI.init(this.skirmishId, this.callback);
        this.dumpSystemStats();
    }

    public int message(int n, String string) {
        this.sendTextMsg("You said: " + string);
        try {
            if (string.equals(".hughai reload")) {
                this.doReloadAI();
            }
            if (this.underlyingAI != null) {
                this.underlyingAI.message(n, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        if (string.equals(".exception")) {
            throw new RuntimeException("generated exception");
        }
        return 0;
    }

    public void triggerReload() throws Exception {
        this.reloadThread = new Thread(new ReloadAIThread());
        this.reloadThread.start();
    }

    public int unitCreated(Unit unit, Unit unit2) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.unitCreated(unit, unit2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int unitFinished(Unit unit) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.unitFinished(unit);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int unitIdle(Unit unit) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.unitIdle(unit);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int unitMoveFailed(Unit unit) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.unitMoveFailed(unit);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int unitDamaged(Unit unit, Unit unit2, float f, AIFloat3 aIFloat3, WeaponDef weaponDef, boolean bl) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.unitDamaged(unit, unit2, f, aIFloat3, weaponDef, bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int unitDestroyed(Unit unit, Unit unit2) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.unitDestroyed(unit, unit2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int unitGiven(Unit unit, int n, int n2) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.unitGiven(unit, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int unitCaptured(Unit unit, int n, int n2) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.unitCaptured(unit, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int enemyEnterLOS(Unit unit) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.enemyEnterLOS(unit);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int enemyLeaveLOS(Unit unit) {
        return 0;
    }

    public int enemyEnterRadar(Unit unit) {
        return 0;
    }

    public int enemyLeaveRadar(Unit unit) {
        return 0;
    }

    public int enemyDamaged(Unit unit, Unit unit2, float f, AIFloat3 aIFloat3, WeaponDef weaponDef, boolean bl) {
        return 0;
    }

    public int enemyDestroyed(Unit unit, Unit unit2) {
        return 0;
    }

    public int weaponFired(Unit unit, WeaponDef weaponDef) {
        return 0;
    }

    public int playerCommand(List<Unit> list, int n, int n2) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.playerCommand(list, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int commandFinished(Unit unit, int n, int n2) {
        try {
            if (this.underlyingAI != null) {
                return this.underlyingAI.commandFinished(unit, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        return 0;
    }

    public int seismicPing(AIFloat3 aIFloat3, float f) {
        return 0;
    }

    class ReloadAIThread
    implements Runnable {
        ReloadAIThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
                HughAILoader.this.doReloadAI();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
        }
    }
}

